<?php

use Core\Migration;

class V530 extends Migration
{
    public function up()
    {
        // create table poll
        $this->execute("CREATE TABLE tbl_polls (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            poll_type INTEGER,
            question TEXT NOT NULL,
            date_start DATETIME,
            date_end DATETIME,
            status INTEGER
        )");

        // create table poll options
        $this->execute("CREATE TABLE tbl_poll_options (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            poll_id INTEGER,
            option_text TEXT NOT NULL,
            sort INTEGER,
            FOREIGN KEY (poll_id) REFERENCES tbl_polls(id) ON DELETE CASCADE
        )");

        // create table poll votes
        $this->execute("CREATE TABLE tbl_poll_votes (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            poll_id INTEGER,
            option_id INTEGER,
            user_ip TEXT,
            voted_at DATE,
            FOREIGN KEY (poll_id) REFERENCES tbl_polls(id) ON DELETE CASCADE,
            FOREIGN KEY (option_id) REFERENCES tbl_poll_options(id) ON DELETE CASCADE
        )");

        $this->execute("CREATE INDEX idx_poll_votes_poll_id ON tbl_poll_votes (poll_id)");
        $this->execute("CREATE INDEX idx_poll_votes_option_id ON tbl_poll_votes (option_id)");

        // add module
        $moduleId = 41;
        $moduleSubId = 9;
        $moduleName = 'polls';
        $moduleIcon = 'far fa-newspaper';
        $moduleAction = 'add|edit|delete|view';

        $this->execute("INSERT
            INTO tbl_modules (id, module, status, sort, icon, action, sub_id)
            VALUES ({$moduleId}, '{$moduleName}', 1, 1, '{$moduleIcon}', '{$moduleAction}', {$moduleSubId})
        ");

        $this->execute("INSERT
            INTO tbl_permissions (id, mod_id, role_id, p_create, p_edit, p_delete, p_view)
            VALUES (NULL, {$moduleId}, 1, 1, 1, 1, 1)
        ");

        // add poll seeds
        $this->execute("INSERT
            INTO tbl_polls (id, poll_type, question, date_start, date_end, status)
            VALUES (1, 3, 'O que você achou da nossa rádio?','2025-04-08 11:00:00', '2080-04-08 11:00:00', 1)
        ");

        $this->execute("INSERT
            INTO tbl_poll_options (id, poll_id, option_text, sort)
            VALUES (1, 1, 'Ótimo', 0)
        ");

        $this->execute("INSERT
            INTO tbl_poll_options (id, poll_id, option_text, sort)
            VALUES (2, 1, 'Bom', 1)
        ");

        $this->execute("INSERT
            INTO tbl_poll_options (id, poll_id, option_text, sort)
            VALUES (3, 1, 'Ruim', 2)
        ");

        $this->execute("INSERT
            INTO tbl_widgets (title, is_title, contents, col, sort, position, type)
            VALUES ('Enquete', 1, '{\"poll\":\"1\"}', 12, 99, 4, 4)
        ");
    }

    public function down() {}
}
